#pragma once

#include "search_result.h"

#include <util/system/mutex.h>
#include <util/generic/string.h>

namespace NSecretSearchGitHook {
    class TOutput {
    public:
        explicit TOutput(IOutputStream& out)
            : out(out)
        {
        }

        ~TOutput() = default;

        virtual void Start() {
        }

        virtual void Finish() {
        }

        virtual void Write(const TDiffResult& result);

        bool Empty() {
            return !headerPrinted;
        }

    protected:
        bool headerPrinted = false;
        IOutputStream& out;
        mutable TMutex outMutex;
    };

}
