#include "search_worker.h"

namespace NSecretSearchGitHook {
    void TSearchWorker::DoExecute() {
        while (true) {
            auto maybeSource = jobsQueue->Pop();
            if (maybeSource.Empty() || AtomicGet(stopped)) {
                break;
            }

            auto source = maybeSource.GetRef();
            auto result = CheckSource(source);

            if (result.Defined()) {
                output->Write(
                    TDiffResult{
                        .Path = source.Path(),
                        .CommitId = source.CommitId(),
                        .SearcherResults = result.GetRef()});
            }
        }
    }

    void TSearchWorker::Stop() {
        AtomicSet(stopped, 1);
    }

}
