#pragma once

#include "diff_source.h"
#include "search_result.h"
#include "output.h"

#include <security/ant-secret/secret-search/internal/ctx.h>
#include <security/ant-secret/secret-search/internal/search_worker.h>

#include <library/cpp/threading/blocking_queue/blocking_queue.h>
#include <library/cpp/deprecated/atomic/atomic.h>
#include <util/generic/string.h>

namespace NSecretSearchGitHook {
    using TJobsQueue = NThreading::TBlockingQueue<TSourceDiff>;

    class TSearchWorker
       : public NSSInternal::TSearchWorkerBase,
          public IThreadFactory::IThreadAble {
    public:
        explicit TSearchWorker(NSSInternal::TContext& ctx)
            : TSearchWorkerBase(ctx)
        {
        }

        void ResetState(TJobsQueue* jobs, TOutput* out) {
            jobsQueue = jobs;
            output = out;
        }

        void DoExecute() override;

        // TODO(buglloc): move to parent
        void Stop();

    protected:
        TAtomic stopped = 0;
        TJobsQueue* jobsQueue = nullptr;
        TOutput* output = nullptr;
    };

}
