#pragma once

#include "diff.h"
#include "search_worker.h"
#include "output.h"

#include <security/ant-secret/secret-search/internal/ctx.h>
#include <security/ant-secret/secret-search/internal/search_worker.h>
#include <security/ant-secret/internal/validation/validator.h>
#include <security/ant-secret/secret-search/public/cpp/output/interface.h>

#include <library/cpp/deprecated/atomic/atomic.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NSecretSearchGitHook {
    struct TSearchOptions {
        TVector<TString> Excludes;
        TString RepoPath;
        bool Validate = true;
        bool ValidOnly = true;
        bool EachRev = true;
        bool SkipKnownSecrets = true;
        bool SkipKnownRevs = true;

        NSSInternal::TContext InternalCtx() const {
            auto validator = new NValidation::TValidator(TString());
            validator->SkipKnown(SkipKnownSecrets);

            return NSSInternal::TContext{
                .Validate = Validate || ValidOnly,
                .ValidOnly = ValidOnly,
                .Validator = THolder(validator),
            };
        }
    };

    class TSearcher {
    public:
        TSearcher(const TSearchOptions& opts, size_t numThreads);

        void CheckDiff(TOutput& writer, const TString& revA, const TString& revB);

        void Stop();

    protected:
        TAtomic stopped = 0;
        TSearchOptions opts;
        NSSInternal::TContext ctx;
        size_t numThreads;
        TDeque<TSearchWorker> workers;
    };

}
