#include <security/ant-secret/secret-search/git-hook/lib/diff.h>
#include <security/ant-secret/secret-search/git-hook/lib/diff_source.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TSourceDiffTests) {
    using namespace NSecretSearchGitHook;

    Y_UNIT_TEST(Simple) {
        TDiff diff{
            .CommitId = "test",
            .SourceFile = "/source",
            .TargetFile = "/target",
            .Fulfilled = true,
            .Removed = {
                {1, "test1"},
                {2, "foo1"},
                {3, "bar1"},
            },
            .Added = {
                {1, "test"},
                {2, "foo"},
                {3, "bar"},
            },
        };

        auto diffSource = TSourceDiff::FromDiff(diff);
        UNIT_ASSERT_STRINGS_EQUAL(diffSource.Path().GetPath(), "/target");
        UNIT_ASSERT_VALUES_EQUAL(diffSource.Size(), 10);
        UNIT_ASSERT(diffSource.IsFulfilled());
        UNIT_ASSERT(!diffSource.IsBinary());
        UNIT_ASSERT(!diffSource.IsLocal());
        UNIT_ASSERT_STRINGS_EQUAL(diffSource.CommitId(), "test");
        UNIT_ASSERT_STRINGS_EQUAL(diffSource.Head(3), "tes");

        size_t lineNo;
        TStringBuf line;
        UNIT_ASSERT(diffSource.ReadLine(lineNo, line));
        UNIT_ASSERT_VALUES_EQUAL(lineNo, 1);
        UNIT_ASSERT_STRINGS_EQUAL(line, "test");

        UNIT_ASSERT(diffSource.ReadLine(lineNo, line));
        UNIT_ASSERT_VALUES_EQUAL(lineNo, 2);
        UNIT_ASSERT_STRINGS_EQUAL(line, "foo");

        UNIT_ASSERT(diffSource.ReadLine(lineNo, line));
        UNIT_ASSERT_VALUES_EQUAL(lineNo, 3);
        UNIT_ASSERT_STRINGS_EQUAL(line, "bar");

        UNIT_ASSERT_STRINGS_EQUAL(diffSource.Content(), "test\nfoo\nbar");
    }
}
