#pragma once

#include <util/string/vector.h>
#include <util/generic/set.h>

namespace NSSInternal {
    namespace NFileWalker {
        class TDirMatcher {
        public:
            explicit TDirMatcher(const TVector<TString>& includes)
                : includes(includes.begin(), includes.end())
            {
            }

            TDirMatcher(const TVector<TString>& includes, const TVector<TString>& excludes)
                : excludes(excludes.begin(), excludes.end())
                , includes(includes.begin(), includes.end())
            {
            }

            bool Match(const TString& dirName) const;

        private:
            const TSet<TString> excludes;
            const TSet<TString> includes;
        };

    }
}
