#pragma once

#include "dir_matcher.h"
#include "path_matcher.h"

#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/folder/path.h>

namespace NSSInternal {
    namespace NFileWalker {
        using TWorkerCb = std::function<bool(const TString& path)>;

        struct TWalkerOptions {
            TVector<TString> Excludes;
        };

        class TWalker {
        public:
            explicit TWalker(const TWalkerOptions& options);

            bool Walk(const TFsPath& rootPath, const TWorkerCb& cb) const;

        private:
            bool WalkImpl(const TString& rootPath, const TWorkerCb& cb, TVector<TPathMatcher>& userExcludes) const;

        private:
            THolder<TDirMatcher> systemExcluder;
        };

    }
}
