#pragma once

#include <library/cpp/regex/pcre/regexp.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NSSInternal {
    namespace NFileWalker {
        class TPathMatcher {
        public:
            TPathMatcher(const TString& prefix, const TVector<TString>& includes);

            TPathMatcher(const TString& prefix, const TVector<TString>& includes, const TVector<TString>& excludes);

            bool Match(const TString& path) const;

            static const TVector<TString> ParsePatterns(const TVector<TString>& patterns);

        private:
            THolder<TRegExMatch> includes;
            THolder<TRegExMatch> excludes;
        };

    }
}
