#include "secrets_ignore.h"

#include <util/stream/file.h>
#include <util/string/strip.h>
#include <util/string/subst.h>

namespace NSSInternal {
    namespace NFileWalker {
        bool TSecretsIgnore::ParseFile(const TString& path, TVector<TString>& includes, TVector<TString>& excludes) {
            TFileInput in(path);
            return Parse(in, includes, excludes);
        }

        bool TSecretsIgnore::Parse(IInputStream& input, TVector<TString>& includes, TVector<TString>& excludes) {
            TString line;
            while (input.ReadLine(line)) {
                if (line.StartsWith("#")) {
                    // Lines starting with # (comments) are ignored before processing
                    continue;
                }

                auto pattern = StripString(line);
                if (pattern.empty()) {
                    continue;
                }

                bool exclude = false;
                if (pattern.StartsWith("!")) {
                    // Excludes
                    exclude = true;
                    pattern.erase(0, 1);
                    pattern = StripString(pattern);
                    if (pattern.empty()) {
                        continue;
                    }
                }

#ifdef _win_
                SubstGlobal(pattern, "/", "\\");
#endif

                if (exclude) {
                    excludes.push_back(pattern);
                } else {
                    includes.push_back(pattern);
                }
            }

            return true;
        }

    }
}
