#include <security/ant-secret/secret-search/internal/filewalker/dir_matcher.h>
#include <library/cpp/testing/unittest/registar.h>

using namespace NSSInternal::NFileWalker;

Y_UNIT_TEST_SUITE(TDirMatcher) {
    Y_UNIT_TEST(Simple) {
        TDirMatcher matcher({"abc", "def"});

        UNIT_ASSERT(matcher.Match("abc"));
        UNIT_ASSERT(matcher.Match("def"));
        UNIT_ASSERT(!matcher.Match("foo"));
    }

    Y_UNIT_TEST(WithExcludes) {
        TDirMatcher matcher({"abc", "def"}, {"def", "bar"});

        UNIT_ASSERT(matcher.Match("abc"));
        UNIT_ASSERT(!matcher.Match("def"));
        UNIT_ASSERT(!matcher.Match("bar"));
        UNIT_ASSERT(!matcher.Match("baz"));
    }
}
