#include <security/ant-secret/secret-search/internal/filewalker/path_matcher.h>
#include <library/cpp/testing/unittest/registar.h>

using namespace NSSInternal::NFileWalker;

Y_UNIT_TEST_SUITE(TPathMatcher) {
    Y_UNIT_TEST(Empty) {
        {
            TPathMatcher matcher("/prefix/", {});

            UNIT_ASSERT(!matcher.Match("/prefix/abc"));
        }

        {
            TPathMatcher matcher("/prefix/", {""}, {""});

            UNIT_ASSERT(!matcher.Match("/prefix/abc"));
        }
    }

    Y_UNIT_TEST(Single) {
        TPathMatcher matcher("/prefix/", {"abc"});

        UNIT_ASSERT(matcher.Match("/prefix/abc"));
    }

    Y_UNIT_TEST(Multiply) {
        TPathMatcher matcher("/prefix/", {"abc?", "a[de]z", "*.test"});

        UNIT_ASSERT(matcher.Match("/prefix/abcZ"));
        UNIT_ASSERT(matcher.Match("/prefix/abcz"));
        UNIT_ASSERT(matcher.Match("/prefix/adz"));
        UNIT_ASSERT(matcher.Match("/prefix/aez"));
        UNIT_ASSERT(matcher.Match("/prefix/foo.test"));
        UNIT_ASSERT(!matcher.Match("/prefix/fooztest"));
        UNIT_ASSERT(!matcher.Match("/prefix/foo"));
        UNIT_ASSERT(matcher.Match("/prefix/abcp"));
    }

    Y_UNIT_TEST(WithExcludes) {
        TPathMatcher matcher("/prefix/", {"abc?", "a[de]z", "*.test"}, {"abcZ", "foo*"});

        UNIT_ASSERT(!matcher.Match("/prefix/abcZ"));
        UNIT_ASSERT(matcher.Match("/prefix/abcz"));
        UNIT_ASSERT(matcher.Match("/prefix/adz"));
        UNIT_ASSERT(matcher.Match("/prefix/aez"));
        UNIT_ASSERT(!matcher.Match("/prefix/foo.test"));
        UNIT_ASSERT(matcher.Match("/prefix/bar.test"));
        UNIT_ASSERT(!matcher.Match("/prefix/fooztest"));
        UNIT_ASSERT(!matcher.Match("/prefix/foo"));
        UNIT_ASSERT(matcher.Match("/prefix/abcp"));
    }

    Y_UNIT_TEST(Nested) {
        TPathMatcher matcher("/prefix/", {"foo/**", "foo1/**/", "**bar", "*.baz"});

        UNIT_ASSERT(matcher.Match("/prefix/foo/123"));
        UNIT_ASSERT(matcher.Match("/prefix/foo/lala/123"));
        UNIT_ASSERT(matcher.Match("/prefix/foo1/123"));
        UNIT_ASSERT(matcher.Match("/prefix/foo1/lala/123"));
        UNIT_ASSERT(matcher.Match("/prefix/test.baz"));
        UNIT_ASSERT(matcher.Match("/prefix/lala/bar"));
        UNIT_ASSERT(matcher.Match("/prefix/lala/test/bar"));
        UNIT_ASSERT(matcher.Match("/prefix/lala/123/test/bar"));
    }
}
