#include <security/ant-secret/secret-search/internal/filewalker/secrets_ignore.h>
#include <library/cpp/testing/unittest/registar.h>
#include <util/folder/tempdir.h>
#include <util/folder/dirut.h>
#include <util/stream/file.h>

using namespace NSSInternal::NFileWalker;

Y_UNIT_TEST_SUITE(TSecretsIgnore) {
    Y_UNIT_TEST(Simple) {
        TVector<TString> includes;
        TVector<TString> excludes;
        TStringStream input(R"(
*
  abc
)");
        bool ok = TSecretsIgnore::Parse(input, includes, excludes);
        UNIT_ASSERT(ok);
        UNIT_ASSERT_EQUAL(includes.size(), 2);
        UNIT_ASSERT_EQUAL(excludes.size(), 0);
        UNIT_ASSERT_STRINGS_EQUAL(includes[0], "*");
        UNIT_ASSERT_STRINGS_EQUAL(includes[1], "abc");
    }

    Y_UNIT_TEST(SimpleFromFile) {
        TTempDir tempDir("nonexistingdir");
        const auto& tempDirPath = tempDir.Path();

        {
            TString secretsIgnoreData = R"(
*
  abc
)";
            TFileOutput secretsIgnore(tempDirPath / ".secretsignore");
            secretsIgnore.Write(secretsIgnoreData);
            secretsIgnore.Flush();
        }

        TVector<TString> includes;
        TVector<TString> excludes;
        bool ok = TSecretsIgnore::ParseFile(tempDirPath / ".secretsignore", includes, excludes);
        UNIT_ASSERT(ok);
        UNIT_ASSERT_EQUAL(includes.size(), 2);
        UNIT_ASSERT_EQUAL(excludes.size(), 0);
        UNIT_ASSERT_STRINGS_EQUAL(includes[0], "*");
        UNIT_ASSERT_STRINGS_EQUAL(includes[1], "abc");
    }

    Y_UNIT_TEST(EmptyLine) {
        TVector<TString> includes;
        TVector<TString> excludes;
        TStringStream input(R"(
# Comment
*
# Must ignore empty inverted rules
!
# Must ignore empty nverted rules with whitespaces
 !

)");
        bool ok = TSecretsIgnore::Parse(input, includes, excludes);
        UNIT_ASSERT(ok);
        UNIT_ASSERT_EQUAL(includes.size(), 1);
        UNIT_ASSERT_EQUAL(excludes.size(), 0);
        UNIT_ASSERT_STRINGS_EQUAL(includes[0], "*");
    }

    Y_UNIT_TEST(Excludes) {
        TVector<TString> includes;
        TVector<TString> excludes;
        TStringStream input(R"(
!abc
! def
)");
        bool ok = TSecretsIgnore::Parse(input, includes, excludes);
        UNIT_ASSERT(ok);
        UNIT_ASSERT_EQUAL(includes.size(), 0);
        UNIT_ASSERT_EQUAL(excludes.size(), 2);
        UNIT_ASSERT_STRINGS_EQUAL(excludes[0], "abc");
        UNIT_ASSERT_STRINGS_EQUAL(excludes[1], "def");
    }

    Y_UNIT_TEST(Complex) {
        TVector<TString> includes;
        TVector<TString> excludes;
        TStringStream input(R"(

# include
*.ce?rt

# but not starts with a
!a*

)");
        bool ok = TSecretsIgnore::Parse(input, includes, excludes);
        UNIT_ASSERT(ok);
        UNIT_ASSERT_EQUAL(includes.size(), 1);
        UNIT_ASSERT_EQUAL(excludes.size(), 1);
        UNIT_ASSERT_STRINGS_EQUAL(includes[0], "*.ce?rt");
        UNIT_ASSERT_STRINGS_EQUAL(excludes[0], "a*");
    }
}
