#pragma once

#include <util/generic/string.h>
#include <library/cpp/json/json_value.h>

#include <utility>

namespace NSSInternal {
    // returns: true if further recursion is needed
    using TJsonWalkerExecutor = std::function<void(const TString&, const TString&)>;

    class TJsonWalker : public NJson::IScanCallback {
    public:
        explicit TJsonWalker(TJsonWalkerExecutor executor)
            : executor(std::move(executor)) {
        }

        bool Do(const TString& path, NJson::TJsonValue* /*parent*/, NJson::TJsonValue& value) final {
            if (value.IsString()) {
                executor(path, value.GetString());
            }

            return true;
        }

    private:
        TJsonWalkerExecutor executor;
    };
}