#include "mime.h"

#include <util/generic/strbuf.h>

namespace NMime {
    namespace {
        const TStringBuf kTextExts[] = {
            "appcache", "manifest", "css", "csv", "tsv", "csvs", "html", "htm", "markdown", "md", "rst", "txt", "asc",
            "text",
            "xml", "log", "cpp", "h", "cc", "hpp", "make", "java", "sh", "bash", "js", "yml", "toml", "json", "conf", "cfg",
            "yql", "sql", "ipynb", "scala", "go", "sls", "pl", "php", "proto", "py"};

    }

    bool IsTextByExt(const TStringBuf ext) {
        for (const auto& textExt : kTextExts) {
            if (ext.equal(textExt)) {
                return true;
            }
        }
        return false;
    }

    bool IsText(const TStringBuf content) {
        if (content.size() < 3) {
            return false;
        } else if (content[0] == '\xEF' && content[1] == '\xBB' && content[2] == '\xBF') {
            // BOM_UTF8
            return true;
        } else if (content[0] == '\xFE' && content[1] == '\xFF' && content[2] != '\x00') {
            // BOM UTF 16 BE
            return true;
        } else if (content[0] == '\xFF' && content[1] == '\xFE' && content[2] != '\x00') {
            // BOM UTF 16 LE
            return true;
        }

        for (unsigned char ch : content) {
            if (ch < 9 || (ch > 13 && ch < 32)) {
                return false;
            }
        }
        return true;
    }

}
