#include <security/ant-secret/secret-search/internal/mime/mime.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TMime) {
    using namespace NMime;

    Y_UNIT_TEST(ByExt) {
        UNIT_ASSERT(IsTextByExt("py"));
        UNIT_ASSERT(IsTextByExt("php"));
        UNIT_ASSERT(IsTextByExt("txt"));

        UNIT_ASSERT(!IsTextByExt("exe"));
        UNIT_ASSERT(!IsTextByExt("dll"));
        UNIT_ASSERT(!IsTextByExt("so"));
        UNIT_ASSERT(!IsTextByExt("sqlite"));
        UNIT_ASSERT(!IsTextByExt("db"));
        UNIT_ASSERT(!IsTextByExt("zip"));
    }

    Y_UNIT_TEST(ByContent) {
        UNIT_ASSERT(IsText(R"(some text)"));
        UNIT_ASSERT(IsText("\xEF\xBB\xBF <- BOM UTF8"));
        UNIT_ASSERT(IsText("\xFE\xFF <- BOM BE"));
        UNIT_ASSERT(IsText("\xFF\xFE <- BOM LE"));
        UNIT_ASSERT(IsText("‘target’"));
        UNIT_ASSERT(IsText(R"(

Multiline
text
)"));

        UNIT_ASSERT(!IsText(""));
        UNIT_ASSERT(!IsText(TStringBuf("\xFE\xED\xFE\xED\x00\x00\x00\x02 <- JKS"sv)));
        UNIT_ASSERT(!IsText(TStringBuf("\x45\x7f\x46\x4c\x01\x02 <- ELF"sv)));
    }
}
