#include "search_result.h"

namespace NSSInternal {
    void TPathResult::ToJson(NJson::TJsonWriter& json) const {
        json.OpenMap();
        json.Write("path", Path);
        json.OpenArray("secrets");
        for (const auto& secret : SearcherResults) {
            secret.ToJson(json);
        }
        json.CloseArray();
        json.CloseMap();
    }

    void TStructResult::ToJson(NJson::TJsonWriter& json) const {
        json.OpenMap();
        json.Write("path", Path);
        json.OpenArray("secrets");
        for (const auto& secret : SearcherResults) {
            secret.ToJson(json);
        }
        json.CloseArray();
        json.CloseMap();
    }
}
