#pragma once

#include "secret.h"

#include <library/cpp/json/json_writer.h>
#include <library/cpp/threading/blocking_queue/blocking_queue.h>

#include <util/generic/string.h>
#include <util/generic/hash.h>

#include <utility>

namespace NSSInternal {
    using TSourceResult = TSecretList;

    struct TPathResult {
        TString Path;
        TSourceResult SearcherResults;

        void ToJson(NJson::TJsonWriter& json) const;
    };

    struct TStructResult {
        TString Path;
        TSourceResult SearcherResults;

        void ToJson(NJson::TJsonWriter& json) const;
    };


    using TPathResultQueue = NThreading::TBlockingQueue<TPathResult>;

}
