#pragma once

#include "source.h"
#include "ctx.h"
#include "searchers.h"
#include "search_result.h"

#include <library/cpp/threading/blocking_queue/blocking_queue.h>
#include <library/cpp/json/json_value.h>

#include <util/thread/factory.h>
#include <util/folder/path.h>

namespace NSSInternal {
    class TSearchWorkerBase {
    public:
        explicit TSearchWorkerBase(TContext& ctx)
            : ctx(ctx)
            , fileSearches(GetFileSearchers(ctx))
            , lineSearches(GetLineSearchers(ctx))
        {
        }

        virtual ~TSearchWorkerBase() = default;

        virtual TMaybe<TPathResult> CheckPath(const TString& path);

        virtual TMaybe<TSourceResult> CheckSource(ISource& source);

        virtual TVector<TStructResult> CheckStruct(NJson::TJsonValue& root);

        virtual void CollectRegexes();

    protected:
        virtual void doCheckFile(ISource& source, TSourceResult& results) const;

        virtual void doCheckLine(ISource& source, TSourceResult& results) const;

    protected:
        TContext& ctx;
        TSearchers fileSearches;
        TSearchers lineSearches;
    };

    class TSearchWorker: public TSearchWorkerBase {
    public:
        explicit TSearchWorker(TContext& ctx)
            : TSearchWorkerBase(ctx){};
    };

    using TJobsQueue = NThreading::TBlockingQueue<TString>;

    class TSearchWorkerThread
       : public TSearchWorkerBase,
          public IThreadFactory::IThreadAble {
    public:
        explicit TSearchWorkerThread(TContext& ctx)
            : TSearchWorkerBase(ctx)
        {
        }

        void ResetQueue(TJobsQueue* jobs, TPathResultQueue* results) {
            jobsQueue = jobs;
            resultsQueue = results;
        }

        void DoExecute() override;

    protected:
        TJobsQueue* jobsQueue = nullptr;
        TPathResultQueue* resultsQueue = nullptr;
    };

}
