#include "searchers.h"

#include "security/ant-secret/secret-search/internal/searchers/all.h"

namespace NSSInternal {
    const TSearchers GetFileSearchers(TContext& ctx) {
        return TSearchers{
            {"jks", new NSearchers::TJks(ctx)},
            {"keys", new NSearchers::TKeys(ctx)},
        };
    }

    const TSearchers GetLineSearchers(TContext& ctx) {
        return TSearchers{
            {"tokens", new NSearchers::TTokens(ctx)}};
    }

}
