#pragma once

#include "interface.h"

#include "security/ant-secret/secret-search/internal/source.h"
#include "security/ant-secret/secret-search/internal/secret.h"
#include <security/ant-secret/secret-search/internal/ctx.h>

#include <util/folder/path.h>
#include <util/generic/string.h>
#include <util/generic/strbuf.h>

namespace NSSInternal {
    namespace NSearchers {
        class TBase: public ISearcher {
        public:
            explicit TBase(TContext& ctx)
                : ctx(ctx)
            {
            }

            ~TBase() override = default;

            bool Binary() const override {
                return false;
            }

            TSecretList CheckFile(ISource& source) override {
                NSSInternal::TSecretList secretList;
                CheckFileTo(source, secretList);
                return secretList;
            }

            void CheckFileTo(ISource& source, TSecretList& list) override {
                Y_UNUSED(source);
                Y_UNUSED(list);
                ythrow TSystemError() << "method CheckFileTo not implemented";
            }

            TSecretList CheckLine(TStringBuf line, size_t lineNo, const TFsPath& path) override {
                NSSInternal::TSecretList secretList;
                CheckLineTo(line, lineNo, path, secretList);
                return secretList;
            }

            void CheckLineTo(TStringBuf line, size_t lineNo, const TFsPath& path, TSecretList& list) override {
                Y_UNUSED(line);
                Y_UNUSED(lineNo);
                Y_UNUSED(path);
                Y_UNUSED(list);
                ythrow TSystemError() << "method CheckLineTo not implemented";
            }

            bool IsAcceptablePath(const TFsPath& path) const override {
                Y_UNUSED(path);
                return true;
            }

        protected:
            TContext& ctx;
        };

    }
}
