#pragma once

#include "security/ant-secret/secret-search/internal/source.h"
#include "security/ant-secret/secret-search/internal/secret.h"

#include <util/folder/path.h>
#include <util/generic/string.h>
#include <util/generic/strbuf.h>

namespace NSSInternal {
    namespace NSearchers {
        class ISearcher {
        public:
            virtual ~ISearcher() = default;

            virtual TSecretList CheckFile(ISource& source) = 0;

            virtual void CheckFileTo(ISource& source, TSecretList& list) = 0;

            virtual TSecretList CheckLine(TStringBuf line, size_t lineNo, const TFsPath& path) = 0;

            virtual void CheckLineTo(TStringBuf line, size_t lineNo, const TFsPath& path, TSecretList& list) = 0;

            virtual bool Binary() const = 0;

            virtual bool IsAcceptablePath(const TFsPath& path) const = 0;
        };

    }
}
