#include "jks.h"

#include <security/ant-secret/internal/string_utils/hash.h>

#include <util/folder/path.h>
#include <util/stream/file.h>
#include <util/stream/buffer.h>

namespace NSSInternal {
    namespace NSearchers {
        namespace {
            constexpr TStringBuf kAndroidJksHash = "6181b2bee4754f0224282497d65bab6e9a439d23";
            constexpr TStringBuf kJksMagic = "\xFE\xED\xFE\xED";
            const TVector<const TStringBuf> kValidExts = {"jks", "keystore"};

        }

        void TJks::CheckFileTo(NSSInternal::ISource& source, NSSInternal::TSecretList& list) {
            if (source.Size() <= kJksMagic.size()) {
                // source size less than needed
                return;
            }

            if (source.Head(kJksMagic.size()) != kJksMagic) {
                // not a JKS container
                return;
            }

            const auto& digest = NStringUtils::Sha1(source.Content());
            NSSInternal::TSecret secret{
                .Type = "JKS",
                .Additional = {{"sha1", digest}}};

            if (kAndroidJksHash == digest) {
                secret.Type = "AndroidJKS";
                secret.Validated = true;
                secret.Additional["jks_purpose"] = "yandex_android";
            } else if (ctx.ValidOnly) {
                // skip not Yandex android JKSes
                return;
            }

            list.push_back(secret);
        }

        bool TJks::IsAcceptablePath(const TFsPath& path) const {
            const auto& ext = path.GetExtension();
            for (const auto& valid : kValidExts) {
                if (valid == ext) {
                    return true;
                }
            }
            return false;
        }

        bool TJks::Binary() const {
            return true;
        }

    }
}
