#pragma once

#include "base.h"

#include <security/ant-secret/secret-search/internal/searchers/ssh_key/ssh_key.h>
#include <security/ant-secret/secret-search/internal/searchers/tls_key/tls_key.h>

#include <util/folder/path.h>

namespace NSSInternal {
    namespace NSearchers {
        class TKeys: public TBase {
        public:
            explicit TKeys(TContext& ctx)
                : TBase(ctx)
            {
            }

            void CheckFileTo(ISource& source, TSecretList& list) override;

            bool IsAcceptablePath(const TFsPath& path) const override;

        protected:
            void
            ProcessTlsKey(const TStringBuf content, const NTlsKey::TTlsKey* key, NSSInternal::TSecretList& list);

            void
            ProcessSshKey(const TStringBuf content, const NSshKey::TSshKey* key, NSSInternal::TSecretList& list);
        };

    }
}
