#pragma once

#include <contrib/libs/openssl/include/openssl/ec.h>
#include <contrib/libs/openssl/include/openssl/rsa.h>
#include <contrib/libs/openssl/include/openssl/dsa.h>

#include <util/generic/string.h>
#include <util/folder/path.h>

namespace NSshKey {
    enum class EKeyType {
        Undef,
        Rsa,
        Dsa,
        Ecdsa256,
        Ecdsa384,
        Ecdsa521,
        Ed25519
    };

    class TSshKey {
    public:
        const TString FingerprintLegacy() const;

        const TString Fingerprint() const;

        static TAutoPtr<TSshKey> FromPem(TStringBuf data, bool throwError = false);

        static TAutoPtr<TSshKey> FromFile(const TFsPath& path, bool throwError = false);

    protected:
        static TAutoPtr<TSshKey> ParseOpensslPem(const TStringBuf data, bool throwError = false);

        static TAutoPtr<TSshKey> ParseOpenssh(const TStringBuf data, bool throwError = false);

    protected:
        struct TPKey {
            EKeyType type = EKeyType::Undef;
            RSA* rsa = nullptr;
            DSA* dsa = nullptr;
            EC_KEY* ecdsa = nullptr;
            TString pubKey;

            ~TPKey() {
                if (rsa != nullptr) {
                    RSA_free(rsa);
                }

                if (dsa != nullptr) {
                    DSA_free(dsa);
                }

                if (ecdsa != nullptr) {
                    EC_KEY_free(ecdsa);
                }
            }

            TString TypeName() const;

            TString PubKey();
        };

        explicit TSshKey(TPKey* pk)
            : pkey(pk)
        {
        }

        THolder<TPKey> pkey;
    };

}
