#pragma once

#include <contrib/libs/openssl/include/openssl/pem.h>

#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/folder/path.h>

namespace NTlsKey {
    class TTlsKey {
    public:
        bool IsValid() const {
            return haveCert && !selfSigned && !expired;
        }

        bool IsSelfSigned() const {
            return selfSigned;
        }

        bool AllowClientAuth() const {
            return clientAuth;
        }

        bool AllowServerAuth() const {
            return serverAuth;
        }

        bool HaveCerts() const {
            return haveCert;
        }

        const TString Subject() const {
            return subject;
        }

        const TString Serial() const {
            return serial;
        }

        TVector<TString> Chain() const {
            return chain;
        }

        static TAutoPtr<TTlsKey> FromPem(TStringBuf data, const TFsPath& path = nullptr, bool throwError = false);

        static TAutoPtr<TTlsKey> FromFile(const TFsPath& path, bool throwError = false);

    protected:
        TTlsKey() = default;

        static TAutoPtr<TTlsKey> FromCertStack(const STACK_OF(X509_INFO) * certStack, bool throwError = false);

    protected:
        bool expired = false;
        bool selfSigned = false;
        bool clientAuth = false;
        bool serverAuth = false;
        bool haveCert = false;
        TString subject;
        TString serial;
        TVector<TString> chain;
    };

}
