#include "base.h"

#include <security/ant-secret/internal/regex_storage/storage.h>

namespace NTokenValidators {
    NSSInternal::TRegexHolder
    CompilePatterns(const TString& name, const TVector<TString>& patterns, const unsigned int flag) {
        TVector<const char*> expressions;
        TVector<unsigned int> ids;
        TVector<unsigned int> flags;

        for (size_t i = 0; i < patterns.size(); ++i) {
            expressions.push_back(patterns[i].data());
            ids.push_back(static_cast<unsigned int>(i));
            flags.push_back(flag);
        }

        return NSSInternal::TRegexStorage::Instance().GetOrCompile(name, expressions, flags, ids);
    }

}
