#include "github.h"

#include <security/ant-secret/internal/string_utils/common.h>
#include <util/string/vector.h>

namespace NTokenValidators {
    TGithub::TGithub(NSSInternal::TContext& ctx)
        : TSimple(ctx, {R"([a-f0-9]{40})"})
    {
    }

    NSSInternal::TSecretAdditional TGithub::ParseAdditional(const NJson::TJsonValue& additional) {
        if (!additional.IsDefined() || !additional.IsMap()) {
            return {};
        }

        return NSSInternal::TSecretAdditional{
            {"github_scopes", additional["scopes"].GetStringSafe()}};
    }

    bool TGithub::IsTokenValid(size_t /*id*/, const TStringBuf token) {
        return NStringUtils::IsHash(token);
    }

    const TString TGithub::Name() const {
        return "github";
    }

    const TString TGithub::SecretType() const {
        return "Github";
    }

    bool TGithub::CanValidate() {
        return true;
    }

}
