#pragma once

#include "simple.h"
#include <security/libs/cpp/hyperscan/hyperscan.h>

namespace NTokenValidators {
    class TGithub: public TSimple {
    public:
        explicit TGithub(NSSInternal::TContext& ctx);

        const TString Name() const override;

        const TString SecretType() const override;

    protected:
        bool IsTokenValid(size_t id, const TStringBuf token) override;

        NSSInternal::TSecretAdditional ParseAdditional(const NJson::TJsonValue& AdditionalInfo) override;

        bool CanValidate() override;
    };

}
