#pragma once

#include "result.h"

#include <util/generic/vector.h>
#include <util/generic/strbuf.h>

namespace NTokenValidators {
    class IValidator {
    public:
        virtual ~IValidator() = default;

        virtual TMaybe<TValidatorResult> Match(const TStringBuf data) = 0;

        virtual TMaybe<TValidatorResult> Validate(const TStringBuf data) = 0;

        virtual TVector<TString> PrefilterPatterns() const = 0;

        virtual bool CanValidate() = 0;

        inline virtual const TString Name() const = 0;

        inline virtual const TString SecretType() const = 0;
    };

}
