#pragma once

#include "simple.h"
#include <security/libs/cpp/hyperscan/hyperscan.h>

namespace NTokenValidators {
    class TJwt: public TSimple {
    public:
        explicit TJwt(NSSInternal::TContext& ctx);

        TMaybe<TValidatorResult> Validate(const TStringBuf data) override;

        const TString Name() const override;

        const TString SecretType() const override;

    protected:
        bool IsTokenValid(size_t id, const TStringBuf token) override;

        bool CanValidate() override;
    };

}
