#pragma once

#include "base.h"
#include <security/ant-secret/secret-search/internal/ctx.h>
#include <security/libs/cpp/hyperscan/hyperscan.h>

namespace NTokenValidators {
    class TSimple: public TBase {
    public:
        TSimple(NSSInternal::TContext& ctx, const TVector<TString>& rawPatterns);

        TMaybe<TValidatorResult> Match(const TStringBuf data) override;

        TMaybe<TValidatorResult> Validate(const TStringBuf data) override;

        TVector<TString> PrefilterPatterns() const override;

    protected:
        virtual bool InitializePatterns();

        virtual TStringBuf FindToken(TStringBuf data);

        virtual bool IsTokenValid(size_t id, const TStringBuf token) = 0;

        virtual NSSInternal::TSecretAdditional ParseAdditional(const NJson::TJsonValue& additionalInfo);

    protected:
        NSSInternal::TContext& ctx;
        TVector<TString> rawPatterns;
        TVector<TString> prefilterPatterns;
        NSSInternal::TRegexHolder re;
    };

}
