#include "slack.h"

namespace NTokenValidators {
    TSlack::TSlack(NSSInternal::TContext& ctx)
        : TSimple(ctx, {R"(xox[baprs]-(?:\d{5,}-)+\w+)"})
    {
    }

    bool TSlack::IsTokenValid(size_t id, const TStringBuf token) {
        Y_UNUSED(id);
        Y_UNUSED(token);
        return true;
    }

    const TString TSlack::Name() const {
        return "slack";
    }

    const TString TSlack::SecretType() const {
        return "Slack";
    }

    bool TSlack::CanValidate() {
        return true;
    }

    NSSInternal::TSecretAdditional TSlack::ParseAdditional(const NJson::TJsonValue& additional) {
        if (Y_UNLIKELY(!additional.IsDefined() || !additional.IsMap())) {
            return {};
        }

        return NSSInternal::TSecretAdditional{
            {"slack_user", additional["user"].GetStringSafe(TString())},
            {"slack_team", additional["team"].GetStringSafe(TString())},
        };
    }

}
