#include "telegram.h"

namespace NTokenValidators {
    TTelegram::TTelegram(NSSInternal::TContext& ctx)
        : TSimple(ctx, {R"([0-9]{8,}:[\w-]{35})"})
    {
    }

    bool TTelegram::IsTokenValid(size_t id, const TStringBuf token) {
        Y_UNUSED(id);
        Y_UNUSED(token);
        return true;
    }

    const TString TTelegram::Name() const {
        return "telegram";
    }

    const TString TTelegram::SecretType() const {
        return "Telegram";
    }

    bool TTelegram::CanValidate() {
        return true;
    }

    NSSInternal::TSecretAdditional TTelegram::ParseAdditional(const NJson::TJsonValue& additional) {
        if (Y_UNLIKELY(!additional.IsDefined() || !additional.IsMap())) {
            return {};
        }

        return NSSInternal::TSecretAdditional{
            {"tg_user", additional["user"].GetStringSafe(TString())},
            {"tg_first_name", additional["first_name"].GetStringSafe(TString())},
        };
    }

}
