#include "tvm.h"

#include <security/ant-secret/internal/string_utils/common.h>

namespace NTokenValidators {
    TTvm::TTvm(NSSInternal::TContext& ctx)
        : TSimple(ctx, {R"([A-Za-z0-9_\-]{22})"})
    {
    }

    bool TTvm::IsTokenValid(size_t id, const TStringBuf token) {
        Y_UNUSED(id);
        return NStringUtils::IsBase64Url(token);
        ;
    }

    const TString TTvm::Name() const {
        return "tvm";
    }

    const TString TTvm::SecretType() const {
        return "TVM";
    }

    NSSInternal::TSecretAdditional TTvm::ParseAdditional(const NJson::TJsonValue& additional) {
        if (Y_UNLIKELY(!additional.IsDefined() || !additional.IsMap())) {
            return {};
        }

        return NSSInternal::TSecretAdditional{
            {"tvm_abc_ids", additional["abc_ids"].GetStringSafe(TString())},
            {"tvm_envs", additional["env_types"].GetStringSafe(TString())},
            {"tvm_client_ids", additional["client_ids"].GetStringSafe(TString())},
            {"tvm_client_names", additional["client_names"].GetStringSafe(TString())},
            {"tvm_creators", additional["creators"].GetStringSafe(TString())},
            {"tvm_resource_ids", additional["resource_ids"].GetStringSafe(TString())},
        };
    }

    bool TTvm::CanValidate() {
        return true;
    }

}
