#include <security/ant-secret/secret-search/internal/searchers/token_validators/yandex_oauth.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TYandexOAuth) {
    using namespace NTokenValidators;

    namespace {
        void checkToken(const TString& token) {
            NSSInternal::TContext ctx{};
            auto searcher = TYandexOAuth(ctx);
            auto result = searcher.Match(token);
            UNIT_ASSERT(result.Defined());
            UNIT_ASSERT_STRINGS_EQUAL(result->Secret, token);
        }

    }

    Y_UNIT_TEST(Legacy) {
        checkToken("03c7c0ace395d80182db07ae2c30f034");
    }

    Y_UNIT_TEST(Embedded) {
        checkToken("AQAD-qJSJpcjAAADwHcUZ2Serk5EmBjzGpemfJQ");
    }

    Y_UNIT_TEST(Embedded_v3) {
        checkToken("y0_AQAAAAAAAYiUAAAAgQAAAAA63mixeHh4eHh4eHh4eHh4eHh4eMmOnSA");
    }

    Y_UNIT_TEST(Stateless) {
        checkToken("1.0.123.2222222222.1111222233000.12350.YRf1SNShCFuRY56E.KO0b4NfG.k0sB3ImkZb5MarhDjgyU5Q");
    }
}
