#include <security/ant-secret/secret-search/internal/searchers/token_validators/yandex_session.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TYandexSession) {
    using namespace NTokenValidators;

    namespace {
        void checkSession(const TString& session) {
            NSSInternal::TContext ctx{};
            auto searcher = TYandexSession(ctx);
            auto result = searcher.Match(session);
            UNIT_ASSERT(result.Defined());
            UNIT_ASSERT_STRINGS_EQUAL(result->Secret, session);
        }

    }

    Y_UNIT_TEST(Classic) {
        checkSession("3:1552306280.5.0.1552217798723:Z8FsXw:1d.1|"
                     "126480966.88482.2.2:88482|"
                     "196108.640870.XXXXXXXXXXXXXXXXXXXX-6SznOg");
    }

    Y_UNIT_TEST(WoKv) {
        checkSession("3:1551182683.5.0.1540542645970:LDh8YjAwYU0MBAAAuAYCKg:43.1|"
                     "88994589.0.302|"
                     "195482.741222.XXXXXXXXXXXXXXXXXXXX-6SznOg");
    }

    Y_UNIT_TEST(Multiple) {
        checkSession("3:1552308886.5.5.1527855241846:UhFYTQ:88.1|"
                     "1120000000001700.20469790.2402.2:20469790|"
                     "1120000000026268.9690762.2002.2:9690762|"
                     "1120000000102258.20726003.2002.0:3.2:20726003|"
                     "1120000000081886.21172253.2402.2:21172253|"
                     "1120000000038691.24012992.2002.2:24012992|"
                     "1120000000123201.24453645.2002.2:24453645|"
                     "134332.183007.XXXXXXXXXXXXXXXXXXXX-6SznOg");
    }

    Y_UNIT_TEST(SessionId2) {
        checkSession("3:1552308886.5.0.1527855241846:UhFYTQ:88.1|"
                     "1120000000001700.-1.400|"
                     "1120000000026268.-1.0|"
                     "1120000000102258.-1.0|"
                     "1120000000081886.-1.400|"
                     "1120000000038691.-1.0|"
                     "1120000000123201.-1.0|"
                     "134332.159643.XXXXXXXXXXXXXXXXXXXX-6SznOg");
    }
}
