#include <security/ant-secret/secret-search/internal/searchers/token_validators/yc_static_cred.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TIAMStaticCred) {
    using namespace NTokenValidators;

    namespace {
        struct TToken {
            TString Token;
            bool IsValid;
        };

        void checkTokens(const TVector<TToken>& tokens) {
            NSSInternal::TContext ctx{};
            auto searcher = TYCStaticCred(ctx);
            for (const auto& token : tokens) {
                auto result = searcher.Match(token.Token);
                if (token.IsValid) {
                    UNIT_ASSERT(result.Defined());
                    UNIT_ASSERT_STRINGS_EQUAL(result->Secret, token.Token);
                } else {
                    UNIT_ASSERT(!result.Defined());
                }
            }
        }
    }

    Y_UNIT_TEST(Match) {
        TVector<TToken> cases = {
            TToken{
                .Token = "YCOFcu7iDT8zC-p0fGkOfEGaaWzHY6TFe3t3av43",
                .IsValid = true,
            },
            TToken{
                .Token = "YCOFcu7iDT8zC-p0fGkOfEGaaWzHY6TFe3t3av42",
                .IsValid = false,
            },
            TToken{
                .Token = "YCOFcu7iDT8zC-p0fGkOfEGaaWzHY6TFe3t3av44",
                .IsValid = false,
            },
            TToken{
                .Token = "Ny4dglUoDiSs98vL3QYuk7KHyHV_sSG_Xyc_fkzG",
                .IsValid = false,
            },
        };

        checkTokens(cases);
    }
}
