#include "yc_apikey.h"

#include <security/ant-secret/internal/string_utils/common.h>
#include <library/cpp/string_utils/base64/base64.h>

namespace NTokenValidators {
    // https://st.yandex-team.ru/ANTSECRET-82

    TYCApiKey::TYCApiKey(NSSInternal::TContext& ctx)
        : TYCApiKeyBase(
              ctx,
              {
                  {R"(AQVN[A-Za-z0-9_-]{36})"},
              })
    {}

    bool TYCApiKey::IsTokenValid(size_t id, const TStringBuf token) {
        Y_UNUSED(id);

        TVector<unsigned char> decoded(Base64DecodeBufSize(token.size()));
        decoded.resize(Base64Decode(decoded.begin(), token.begin(), token.end()));

        return (
          decoded.size() == 30 &&
          decoded[0] == 1 &&
          decoded[1] == 0x05 &&
          decoded[2] == 0x4d &&
          (decoded[3] >= 0xc0 && decoded[3] <= 0xdf)
        );
    }

    const TString TYCApiKey::Name() const {
        return "yc-apikey";
    }

    const TString TYCApiKey::SecretType() const {
        return "YCApiKey";
    }

    bool TYCApiKey::CanValidate() {
        return true;
    }
}
