#pragma once

#include "simple.h"

namespace NTokenValidators {
    class TYCApiKeyBase: public TSimple {
    public:
        TYCApiKeyBase(NSSInternal::TContext& ctx, const TVector<TString>& rawPatterns): TSimple(ctx, rawPatterns) {};

        NSSInternal::TSecretAdditional ParseAdditional(const NJson::TJsonValue& additionalInfo) override {
            if (!additionalInfo.IsDefined() || !additionalInfo.IsMap()) {
                return {};
            }

            return NSSInternal::TSecretAdditional{
                {"account_id", additionalInfo["account_id"].GetString()},
                {"folder_id", additionalInfo["folder_id"].GetString()},
                {"subject_type", additionalInfo["kind"].GetString()},
                {"environment", additionalInfo["env"].GetString()},
            };
        }
    };
}
