#include "yc_cookie.h"

#include <security/ant-secret/internal/string_utils/common.h>
#include <util/string/vector.h>

namespace NTokenValidators {
    // https://st.yandex-team.ru/ANTSECRET-82

    TYCCookie::TYCCookie(NSSInternal::TContext& ctx)
        : TYCApiKeyBase(
              ctx,
              {
                  {R"(c1\.[A-Z0-9a-z_-]+[=]{0,2}\.[A-Z0-9a-z_-]{86}[=]{0,2})"},
              })
    {}

    bool TYCCookie::IsTokenValid(size_t id, const TStringBuf token) {
        Y_UNUSED(id);

        const auto& parts = SplitString(TString(token), ".");
        if (parts.size() != 3) {
            return false;
        }

        return NStringUtils::IsBase64UrlRaw(parts[1]) && NStringUtils::IsBase64UrlRaw(parts[2]);
    }

    const TString TYCCookie::Name() const {
        return "yc-cookie";
    }

    const TString TYCCookie::SecretType() const {
        return "YCCookie";
    }

    bool TYCCookie::CanValidate() {
        return true;
    }
}
