#include "yc_static_cred.h"

#include <security/ant-secret/internal/string_utils/common.h>
#include <library/cpp/string_utils/base64/base64.h>
#include <library/cpp/digest/crc32c/crc32c.h>

namespace NTokenValidators {
    // https://st.yandex-team.ru/CLOUD-80368

    TYCStaticCred::TYCStaticCred(NSSInternal::TContext& ctx)
        : TYCApiKeyBase(
              ctx,
              {
                  {R"(YC[A-Za-z0-9_-]{38})"},
              })
    {}

    bool TYCStaticCred::IsTokenValid(size_t id, const TStringBuf token) {
        Y_UNUSED(id);

        TVector<unsigned char> decoded(Base64DecodeBufSize(token.size()));
        decoded.resize(Base64Decode(decoded.begin(), token.begin(), token.end()));

        ui32 expectedChecksum = 0;
        for (size_t idx = decoded.size() - 4; idx < decoded.size(); ++idx) {
            expectedChecksum <<= 8;
            expectedChecksum |= static_cast<unsigned char>(decoded[idx]);
        }

        ui32 actualChecksum = Crc32c(decoded.data(), decoded.size() - 4);
        return actualChecksum == expectedChecksum;
    }

    const TString TYCStaticCred::Name() const {
        return "yc-static-cred";
    }

    const TString TYCStaticCred::SecretType() const {
        return "YCStaticCred";
    }

    bool TYCStaticCred::CanValidate() {
        return false;
    }
}
