#include "yc_token.h"

#include <security/ant-secret/internal/string_utils/common.h>
#include <util/string/vector.h>
#include <util/string/join.h>

namespace NTokenValidators {
    // https://st.yandex-team.ru/ANTSECRET-82

    TYCToken::TYCToken(NSSInternal::TContext& ctx)
        : TYCApiKeyBase(
              ctx,
              {
                  {R"(t1\.[A-Z0-9a-z_-]+[=]{0,2}\.[A-Z0-9a-z_-]{86}[=]{0,2})"},
              })
    {}

    bool TYCToken::IsTokenValid(size_t id, const TStringBuf token) {
        Y_UNUSED(id);

        const auto& parts = SplitString(TString(token), ".");
        if (parts.size() != 3) {
            return false;
        }

        return NStringUtils::IsBase64UrlRaw(parts[1]) && NStringUtils::IsBase64UrlRaw(parts[2]);
    }

    const TString TYCToken::Name() const {
        return "yc-token";
    }

    const TString TYCToken::SecretType() const {
        return "YCToken";
    }

    bool TYCToken::CanValidate() {
        return true;
    }
}
