#pragma once

#include "base.h"

#include <security/ant-secret/secret-search/internal/searchers/token_validators/interface.h>
#include <security/ant-secret/internal/regex_storage/storage.h>

#include <security/libs/cpp/hyperscan/hyperscan.h>
#include <util/folder/path.h>

namespace NSSInternal {
    namespace NSearchers {
        class TTokens: public TBase {
        public:
            explicit TTokens(TContext& ctx);

            void CheckLineTo(TStringBuf line, size_t lineNo, const TFsPath& path, TSecretList& secrets) override;

        private:
            TMaybe<TSecret> ValidateBy(TStringBuf data, NTokenValidators::IValidator* validator);

        private:
            TVector<THolder<NTokenValidators::IValidator>> validators;
            THashMap<size_t, size_t> tokenToValidator;
            TRegexHolder keywordsRe;
            TRegexHolder prefilterRe;
            TRegexHolder tokensRe;
        };

    }
}
