#pragma once

#include <library/cpp/json/json_writer.h>

#include <util/generic/string.h>
#include <util/generic/hash.h>

namespace NSSInternal {
    using TSecretAdditional = THashMap<TString, TString>;

    struct TSecret {
        TString Type;
        TString Secret;
        TString SourceLine;
        size_t LineNo = 0;
        bool Validated = false;
        bool ValidationError = false;
        bool Ignore = false;
        TDeque<TString> Owners;
        TSecretAdditional Additional;

        void ToJson(NJson::TJsonWriter& json) const;

        const TString ShortAdditional() const;

        const TString HumanType() const;
    };

    using TSecretList = TVector<TSecret>;

}
