#include "source.h"

#include <security/ant-secret/secret-search/internal/mime/mime.h>

namespace NSSInternal {
    TSourceFile::TSourceFile(const TString& path)
        : filePath(path)
        , fileIn(new TFileInput(path))
        , eof(false)
    {
    }

    TSourceFile::TSourceFile(const TFsPath& path)
        : filePath(path)
        , fileIn(new TFileInput(path))
        , eof(false)
    {
    }

    const TStringBuf TSourceFile::Head(size_t len) {
        if (len > content.size()) {
            readBuff(len - content.size());
        }
        return TStringBuf(content.data(), std::min(len, content.size()));
    }

    const TStringBuf TSourceFile::Content() {
        if (eof) {
            return TStringBuf(content);
        }

        readBuff(0);
        return TStringBuf(content);
    }

    bool TSourceFile::IsBinary() {
        if (!isBinary) {
            // fast way
            bool isText = NMime::IsTextByExt(filePath.GetExtension());
            if (!isText) {
                // slow way :(
                isText = NMime::IsText(Head(NMime::HeaderSize));
            }
            isBinary.Reset(new bool(!isText));
        }

        return *(isBinary.Get());
    }

    bool TSourceFile::IsLocal() {
        return true;
    }

    bool TSourceFile::IsFulfilled() {
        return true;
    }

    size_t TSourceFile::Size() {
        if (!fileSt) {
            fileSt.Reset(new TFileStat(filePath.GetPath()));
        }
        return fileSt->Size;
    }

    const TFsPath TSourceFile::Path() {
        return filePath;
    }

    void TSourceFile::readBuff(size_t len) {
        if (len == 0) {
            len = Size() + 1;
        }

        TTempBuf buffer;
        void* ptr = buffer.Data();
        size_t size = buffer.Size();

        while (!eof && len) {
            size_t read = fileIn->Read(ptr, size);
            if (!read) {
                eof = true;
                break;
            }

            content.append((const char*)ptr, read);
            len -= read;
        }
    }

    bool TSourceFile::ReadLine(size_t& lineNo, TStringBuf& line) {
        if (!readContentReady) {
            readContent = Content();
            readContentReady = true;
        }
        lineNo = ++curLine;
        return readContent.ReadLine(line);
    }

    TSourceContent::TSourceContent(const TString& content)
        : content(content)
    {
    }

    const TStringBuf TSourceContent::Head(size_t len) {
        return TStringBuf(content.data(), std::min(len, content.size()));
    }

    const TStringBuf TSourceContent::Content() {
        return content;
    }

    const TFsPath TSourceContent::Path() {
        return nullptr;
    }

    bool TSourceContent::ReadLine(size_t& lineNo, TStringBuf& line) {
        if (!readContentReady) {
            readContent = Content();
            readContentReady = true;
        }
        lineNo = ++curLine;
        return readContent.ReadLine(line);
    }

    bool TSourceContent::IsBinary() {
        if (!isBinary) {
            isBinary.Reset(new bool(!NMime::IsText(Head(NMime::HeaderSize))));
        }

        return *(isBinary.Get());
    }

    bool TSourceContent::IsLocal() {
        return false;
    }

    bool TSourceContent::IsFulfilled() {
        return true;
    }

    size_t TSourceContent::Size() {
        return content.size();
    }

}
