#pragma once

#include <util/generic/string.h>
#include <util/folder/path.h>
#include <util/system/file.h>
#include <util/stream/file.h>

namespace NSSInternal {
    class ISource {
    public:
        virtual ~ISource() = default;

        virtual const TStringBuf Head(size_t len) = 0;

        virtual const TStringBuf Content() = 0;

        virtual const TFsPath Path() = 0;

        virtual bool IsBinary() = 0;

        virtual bool IsLocal() = 0;

        virtual bool IsFulfilled() = 0;

        virtual bool ReadLine(size_t& lineNo, TStringBuf& line) = 0;

        virtual size_t Size() = 0;
    };

    class TSourceFile: public NSSInternal::ISource {
    public:
        explicit TSourceFile(const TString& path);

        explicit TSourceFile(const TFsPath& path);

        const TStringBuf Head(size_t len) override;

        const TStringBuf Content() override;

        const TFsPath Path() override;

        bool IsBinary() override;

        bool IsLocal() override;

        bool IsFulfilled() override;

        size_t Size() override;

        bool ReadLine(size_t& lineNo, TStringBuf& line) override;

        void readBuff(size_t len);

    protected:
        const TFsPath filePath;
        THolder<TFileStat> fileSt;
        THolder<TFileInput> fileIn;
        TString content;
        size_t curLine = 0;
        TStringBuf readContent;
        bool readContentReady = false;
        THolder<bool> isBinary;
        bool eof;
    };

    class TSourceContent: public NSSInternal::ISource {
    public:
        explicit TSourceContent(const TString& content);

        const TStringBuf Head(size_t len) override;

        const TStringBuf Content() override;

        const TFsPath Path() override;

        bool IsBinary() override;

        bool IsLocal() override;

        bool IsFulfilled() override;

        bool ReadLine(size_t& lineNo, TStringBuf& line) override;

        size_t Size() override;

    protected:
        size_t curLine = 0;
        TString content;
        TStringBuf readContent;
        bool readContentReady = false;
        THolder<bool> isBinary;
    };

}
