#include <security/ant-secret/secret-search/internal/search_result.h>

#include <library/cpp/testing/unittest/registar.h>
#include <util/stream/str.h>

Y_UNIT_TEST_SUITE(TSearchResultTests) {
    using namespace NSSInternal;

    Y_UNIT_TEST(JsonWriteSimple) {
        TSecretList secrets{{
            .Type = "TestType",
            .Secret = "secret",
            .SourceLine = "source",
            .LineNo = 1,
            .Validated = true,
            .Ignore = true,
        }};

        TPathResult result{
            .Path = "/test",
            .SearcherResults = secrets,
        };

        TStringStream out;
        NJson::TJsonWriter json(&out, /*formatOutput*/ false, /*sortkeys*/ true, /*validateUtf8*/ true);
        result.ToJson(json);
        json.Flush();
        UNIT_ASSERT_STRINGS_EQUAL(
            out.Str(),
            R"({"path":"/test","secrets":[{"type":"TestType","secret":"secret","validated":true,"line_no":1,"source_line":"source"}]})");
    }
}
