#include <security/ant-secret/secret-search/internal/secret.h>

#include <library/cpp/testing/unittest/registar.h>
#include <util/stream/str.h>

Y_UNIT_TEST_SUITE(TSecretTests) {
    using namespace NSSInternal;

    Y_UNIT_TEST(JsonWriteSimple) {
        TSecret secret{
            .Type = "test",
            .Secret = "secret",
            .SourceLine = "source",
            .LineNo = 1,
            .Validated = true,
            .Ignore = true,
        };

        TStringStream out;
        NJson::TJsonWriter json(&out, /*formatOutput*/ false, /*sortkeys*/ true, /*validateUtf8*/ true);
        secret.ToJson(json);
        json.Flush();
        UNIT_ASSERT_STRINGS_EQUAL(
            out.Str(),
            R"({"type":"test","secret":"secret","validated":true,"line_no":1,"source_line":"source"})");
    }

    Y_UNIT_TEST(JsonWriteAdditional) {
        TSecret secret{
            .SourceLine = "source",
            .LineNo = 1,
            .Additional = {
                {"key1", "val1"},
                {"key2", "val2"},
                {"empty", ""},
            }};

        TStringStream out;
        NJson::TJsonWriter json(&out, /*formatOutput*/ false, /*sortkeys*/ true, /*validateUtf8*/ true);
        secret.ToJson(json);
        json.Flush();
        UNIT_ASSERT_STRINGS_EQUAL(
            out.Str(),
            R"({"validated":false,"line_no":1,"source_line":"source","additional":{"key1":"val1","key2":"val2"}})");
    }

    Y_UNIT_TEST(IvalidUTFInSource) {
        TSecret secret{
            .SourceLine = "lala\xEElala",
            .LineNo = 1,
        };

        TStringStream out;
        NJson::TJsonWriter json(&out, /*formatOutput*/ false, /*sortkeys*/ false, /*validateUtf8*/ true);
        secret.ToJson(json);
        json.Flush();
    }

    Y_UNIT_TEST(ShortAdditional) {
        TSecret secret{
            .Type = "YOAuthInternal",
            .SourceLine = "lala",
            .LineNo = 1,
            .Additional = {
                {"secret_users", "test_user"}}};

        UNIT_ASSERT_STRINGS_EQUAL(secret.ShortAdditional(), "users=test_user");
    }

    Y_UNIT_TEST(HumanType) {
        TSecret secret{
            .Type = "YOAuthInternal",
            .SourceLine = "lala",
            .LineNo = 1,
            .Additional = {
                {"secret_users", "test_user"}}};

        UNIT_ASSERT_STRINGS_EQUAL(secret.HumanType(), "Yandex team OAuth token");
    }
}
