#include <security/ant-secret/secret-search/internal/source.h>

#include <library/cpp/testing/unittest/registar.h>
#include <util/stream/str.h>
#include <util/folder/tempdir.h>
#include <util/folder/dirut.h>

Y_UNIT_TEST_SUITE(TSourceTests) {
    using namespace NSSInternal;

    Y_UNIT_TEST(TSourceContentTest) {
        TSourceContent source("test");

        UNIT_ASSERT_EQUAL(source.Size(), 4);
        UNIT_ASSERT_STRINGS_EQUAL(source.Content(), "test");
        UNIT_ASSERT_STRINGS_EQUAL(source.Head(2), "te");
        UNIT_ASSERT_STRINGS_EQUAL(source.Head(1000), "test");
        UNIT_ASSERT(!source.Path());
        UNIT_ASSERT(!source.IsBinary());
    }

    Y_UNIT_TEST(TSourceContentBinaryTest) {
        TSourceContent source("te\x02st");

        UNIT_ASSERT_EQUAL(source.Size(), 5);
        UNIT_ASSERT_STRINGS_EQUAL(source.Content(), "te\x02st");
        UNIT_ASSERT_STRINGS_EQUAL(source.Head(2), "te");
        UNIT_ASSERT_STRINGS_EQUAL(source.Head(1000), "te\x02st");
        UNIT_ASSERT(!source.Path());
        UNIT_ASSERT(source.IsBinary());
    }

    Y_UNIT_TEST(TSourceFileTest) {
        TTempDir tempDir("nonexistingdir");
        const auto& tempDirPath = tempDir.Path();

        const auto fileName = tempDirPath / "file.txt";
        TFileOutput file(fileName);
        file << "test";
        file.Finish();

        TSourceFile source(fileName);

        UNIT_ASSERT(!source.IsBinary());
        UNIT_ASSERT_EQUAL(source.Size(), 4);
        UNIT_ASSERT_STRINGS_EQUAL(source.Head(2), "te");
        UNIT_ASSERT_STRINGS_EQUAL(source.Head(1000), "test");
        UNIT_ASSERT_STRINGS_EQUAL(source.Content(), "test");
        UNIT_ASSERT(source.Path());
        UNIT_ASSERT_STRINGS_EQUAL(source.Path().GetExtension(), "txt");
        UNIT_ASSERT_STRINGS_EQUAL(source.Path().GetName(), "file.txt");
    }

    Y_UNIT_TEST(TSourceFileBinaryTest) {
        TTempDir tempDir("nonexistingdir");
        const auto& tempDirPath = tempDir.Path();

        const auto fileName = tempDirPath / "file";
        TFileOutput file(fileName);
        file << "tes\x03t";
        file.Finish();

        TSourceFile source(fileName);

        UNIT_ASSERT(source.IsBinary());
        UNIT_ASSERT_EQUAL(source.Size(), 5);
        UNIT_ASSERT_STRINGS_EQUAL(source.Head(2), "te");
        UNIT_ASSERT_STRINGS_EQUAL(source.Head(1000), "tes\x03t");
        UNIT_ASSERT_STRINGS_EQUAL(source.Content(), "tes\x03t");
        UNIT_ASSERT(source.Path());
        UNIT_ASSERT_STRINGS_EQUAL(source.Path().GetExtension(), "");
        UNIT_ASSERT_STRINGS_EQUAL(source.Path().GetName(), "file");
    }
}
