#pragma once

#include "interface.h"
#include <security/ant-secret/secret-search/public/cpp/search_result.h>

#include <util/stream/str.h>

namespace NSecretSearch {
    namespace NOutput {
        class TBase: public IWriter {
        public:
            explicit TBase(IOutputStream& out)
                : out(out)
            {
            }

            ~TBase() override = default;

            void Write(const TPathResult& result) override = 0;

            void Start() override{};

            void Finish() override{};

        protected:
            IOutputStream& out;
        };

    }
}
